package services.poi;

import java.io.BufferedReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import postgres.poi.PoiCharacteristics;
import postgres.poi.PostgreSQLFunctions;

import description.HTMLDescription;
import description.ServiceDescription;

/**
 * Servlet implementation class AddNewPOIs
 */
@WebServlet("/AddNewPOIs")
public class AddNewPOIs extends HttpServlet {
	private static final long serialVersionUID = 1L;
	private ServiceDescription description;
       
    /**
     * @see HttpServlet#HttpServlet()
     */
    public AddNewPOIs() {
        super();
        this.description = new HTMLDescription("Add new POIs");
        this.description.addParameter("List Of POI objects", "POIList");
        this.description.setReturnValue("boolean");
        this.description.setDescription("Web service used to add a list of POIs");
        // TODO Auto-generated constructor stub
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		if(request.getParameter("info")!=null){
			response.getOutputStream().print(this.description.serialize());
		} else if(request.getParameter("POILIst")==null){
			response.sendError(HttpServletResponse.SC_BAD_REQUEST);
		} 
		else {
			response.getOutputStream().print("i am hereeeee");
			
			PostgreSQLFunctions postgres = new PostgreSQLFunctions();
			ArrayList<PoiCharacteristics> listOfPOIs = new ArrayList<PoiCharacteristics>();
			Connection con = null;
			boolean result = false;
			boolean json = false;
			
			String msgChoice = request.getParameter("format");

			String poi_id = null;
			double x = -1;
			double y = -1;
			int interest = -1; 
			int hotness =  -1;
			boolean publicity = false;
			String keywords = null;
			JSONArray keywordsJson = null;
			
			StringBuffer jb = new StringBuffer();
			String line = null;
			BufferedReader reader = request.getReader();
			while ((line = reader.readLine()) != null){
				jb.append(line);
			}

			JSONObject jsonObj = new JSONObject(jb);
			
			try {
				poi_id = jsonObj.getString("poi_id");
				x = jsonObj.getDouble("x");
				y = jsonObj.getDouble("y");
				interest = jsonObj.getInt("interest");
				hotness = jsonObj.getInt("hotness");
				publicity = jsonObj.getBoolean("publicity");
				keywordsJson = jsonObj.getJSONArray("Keywords");
				if ( keywordsJson.length() != 0){
					keywords = keywordsJson.getString(0);
					for ( int i = 1 ; i < keywordsJson.length() ; i ++ ){
						keywords = keywords + "," + keywordsJson.getString(0);
					}
				}			
			} catch (JSONException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			
			
			String msgResponse = null;
			
			PoiCharacteristics poiChar = new PoiCharacteristics(poi_id,x,y,interest,hotness,publicity,keywords, description,null);
			listOfPOIs.add(poiChar);
			
			
			try {
				con = postgres.OpenConnection();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
			try {
				result = postgres.addNewPOIs(con, listOfPOIs);
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
			try {
				postgres.CloseConnection(con);
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		
			if (msgChoice.equals("json")){		
				msgResponse = "{\"result\":\" " + result + "\"}";
			}
			else{
				msgResponse = "callback({\"result\":\" " + result + "\"})";
			}
			response.getOutputStream().print(msgResponse);
		}
		
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
	}

}
