package postgres.poi;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.io.BufferedReader;
import java.sql.Connection;
import java.sql.Timestamp;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PoiCriteria {
    String user_id = null;
    Timestamp start_time = null;
    Timestamp end_time = null;
    double x1Region = -1;
    double y1Region = -1;
    double x2Region = -1;
    double y2Region = -1;
    ArrayList<String> friendsList = null;
    String orderBy = null;
    int noOfResults = -1;
    String keywords = null;
    ArrayList<String> keywordsList = null;
    //Timestamp myTimestamp = new Timestamp((new java.util.Date()).getTime());
    
    
    public PoiCriteria ( String user_id, Timestamp start_time, Timestamp end_time, double x1Region, double y1Region, double x2Region, double y2Region, String friends, String orderBy, int noOfResults, String keywords){
        this.start_time = start_time;
        this.end_time = end_time;
        this.x1Region = x1Region;
        this.y1Region = y1Region;
        this.x2Region = x2Region;
        this.y2Region = y2Region;
        if ( friends != null ){
            friendsList = new ArrayList<String>();
            if ( friends.contains(",")){
                String []temp;
                temp = friends.split(",");
                if ( temp.length != 0 ){
                    for (int i = 0; i < temp.length ; i++ ){
                        friendsList.add(temp[i]);
                    }
                }
            }
            else{
                friendsList.add(friends);
            }
        }
        else{
            friendsList = null;
        }
        this.orderBy = orderBy;
        this.noOfResults = noOfResults;
        this.keywords = keywords;
        if ( keywords != null ){
            keywordsList = new ArrayList<String>();
            if (keywords.contains(",")){
                String []temp;
                temp = keywords.split(",");
                if ( temp.length != 0 ){
                    for (int i = 0; i < temp.length ; i++ ){
                        keywordsList.add(temp[i]);
                    }
                }
            }
            else{
                keywordsList.add(keywords);
            }
        }
        else{
            keywordsList = null;
        }
    }
    
    public String toString(){
    	String str = null;
    	str = start_time + "," + end_time + "," + x1Region + "," + y1Region + "," + x2Region +"," + y2Region + "," + friendsList.toString() + "," + orderBy + "," + noOfResults + "," + keywords; 
    	return str;
    }
    
    public PoiCriteria(StringBuffer jb){
		String endTimeStamp = null;
		String startTimeStamp = null; 
		JSONArray region = null;
		String orderBy = null;
		int numberOfResults = -1;
		JSONArray keywordsJson = null;
		JSONArray friendsListJson = null;
		

		JSONObject jsonObj = new JSONObject(jb);

		try {
			endTimeStamp = jsonObj.getString("End");
			startTimeStamp = jsonObj.getString("Start"); 
			region = jsonObj.getJSONArray("Region");
			orderBy = jsonObj.getString("OrderBy");
			numberOfResults = jsonObj.getInt("NoOfResults");
			keywordsJson = jsonObj.getJSONArray("Keywords");
			friendsListJson = jsonObj.getJSONArray("FriendsList");
		} catch (JSONException e2) {
			// TODO Auto-generated catch block
			e2.printStackTrace();
		}
		
		SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
        java.util.Date parsedDate = null;
		try {
			parsedDate = dateFormat.parse(startTimeStamp);
		} catch (ParseException e2) {
			// TODO Auto-generated catch block
			e2.printStackTrace();
		}
        start_time = new java.sql.Timestamp(parsedDate.getTime());
        
        try {
			parsedDate = dateFormat.parse(endTimeStamp);
		} catch (ParseException e2) {
			// TODO Auto-generated catch block
			e2.printStackTrace();
		}
        end_time = new java.sql.Timestamp(parsedDate.getTime());
			

		try {
			JSONObject region1 = new JSONObject();
			JSONObject region2 = new JSONObject();
			region1 = region.getJSONObject(0);
			x1Region = region1.getDouble("lat");
			y1Region = region1.getDouble("lon");
			region2 = region.getJSONObject(1);
			x2Region = region2.getDouble("lat");
			y2Region = region2.getDouble("lon");
			if ( friendsListJson.length() != 0){
				friendsList.add(friendsListJson.getString(0));
				for ( int i = 1 ; i < friendsListJson.length() ; i ++ ){
					friendsList.add(friendsListJson.getString(0));
				}
			}
			if ( keywordsJson.length() != 0){
				keywordsList.add(keywordsJson.getString(0));
				for ( int i = 1 ; i < keywordsJson.length() ; i ++ ){
					keywordsList.add(keywordsJson.getString(0));
				}
			}
		} catch (JSONException e2) {
			// TODO Auto-generated catch block
			e2.printStackTrace();
		}
    	
    }

    
    //////////////////////////get///////////////////////


    public String getUser_id() {
        return user_id;
    }

    public Timestamp getStart_time() {
        return start_time;
    }

    public Timestamp getEnd_time() {
        return end_time;
    }

    public Double getX1Region() {
        return x1Region;
    }

    public Double getY1Region() {
        return y1Region;
    }

    public Double getX2Region() {
        return x2Region;
    }

    public Double getY2Region() {
        return y2Region;
    }

    public ArrayList<String> getFriendsList() {
        return friendsList;
    }

    public String getOrderBy() {
        return orderBy;
    }

    public int getNoOfResults() {
        return noOfResults;
    }

    public String getKeywords() {
        return keywords;
    }

    public ArrayList<String> getKeywordsList() {
        return keywordsList;
    }
    
    ////////////////////////////set////////////////////////////////

    public void setUser_id(String user_id) {
        this.user_id = user_id;
    }

    public void setStart_time(Timestamp start_time) {
        this.start_time = start_time;
    }

    public void setEnd_time(Timestamp end_time) {
        this.end_time = end_time;
    }

    public void setX1Region(double x1Region) {
        this.x1Region = x1Region;
    }

    public void setY1Region(double y1Region) {
        this.y1Region = y1Region;
    }

    public void setX2Region(double x2Region) {
        this.x2Region = x2Region;
    }

    public void setY2Region(double y2Region) {
        this.y2Region = y2Region;
    }

    public void setFriendsList(ArrayList<String> friendsList) {
        this.friendsList = friendsList;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public void setNoOfResults(int noOfResults) {
        this.noOfResults = noOfResults;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public void setKeywordsList(ArrayList<String> keywordsList) {
        this.keywordsList = keywordsList;
    }
    
}
