package services.poi;

import java.io.BufferedReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import postgres.poi.PoiCharacteristics;
import postgres.poi.PoiCriteria;
import postgres.poi.PostgreSQLFunctions;

import description.HTMLDescription;
import description.ServiceDescription;

/**
 * Servlet implementation class GetPOIs
 */
@WebServlet("/GetPOIs")
public class GetPOIs extends HttpServlet {
	private static final long serialVersionUID = 1L;
	private ServiceDescription description;
    /**
     * @see HttpServlet#HttpServlet()
     */
    public GetPOIs() {
        super();
        this.description = new HTMLDescription("Get POIs");
        this.description.addParameter("TimeStamp", "Start");
        this.description.addParameter("TimeStamp", "End");
        this.description.addParameter("Rectangle", "Region");
        this.description.addParameter("List Of Strings", "FriendsList");
        this.description.addParameter("String", "OrderBy");
        this.description.addParameter("Integer", "NoOfResults");
        this.description.addParameter("List of Strings", "Keywords");
        this.description.setReturnValue("List Of POI objects"); 
        this.description.setDescription("Web service used to return a list of objects satisfying certain criteria");
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		if(request.getParameter("info")!=null){
			response.getOutputStream().print(this.description.serialize());
		} 
		/*else if(request.getParameter("userid")==null || request.getParameter("poiid")==null){
			response.sendError(HttpServletResponse.SC_BAD_REQUEST);
		}*/
		else{
			PostgreSQLFunctions postgres = new PostgreSQLFunctions();
			ArrayList<PoiCharacteristics> listOfPOIs = null;
			Connection con = null;
			
			String startTime = request.getParameter("stime"); 
			String endTime = request.getParameter("etime");
			String x1 = request.getParameter("x1");
			String y1 = request.getParameter("y1");
			String x2 = request.getParameter("x2");
			String y2 = request.getParameter("y2");
			String friends = request.getParameter("friends");
			String orderBy = request.getParameter("orderby");
			String numberOfResults = request.getParameter("nresults");
			String keywords = request.getParameter("keywords");
			
			SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
	        java.util.Date parsedDate = null;
			try {
				parsedDate = dateFormat.parse(startTime);
			} catch (ParseException e2) {
				// TODO Auto-generated catch block
				e2.printStackTrace();
			}
	        java.sql.Timestamp start_time = new java.sql.Timestamp(parsedDate.getTime());
	        
	        try {
				parsedDate = dateFormat.parse(endTime);
			} catch (ParseException e2) {
				// TODO Auto-generated catch block
				e2.printStackTrace();
			}
	        java.sql.Timestamp end_time = new java.sql.Timestamp(parsedDate.getTime());
			
			
	        
			String msgResponse = null;
			String msgChoice = request.getParameter("format");
			
			
			PoiCriteria poiCrit = new PoiCriteria(null,start_time,end_time,Double.parseDouble(x1),Double.parseDouble(y1),Double.parseDouble(x2),Double.parseDouble(y2),friends,orderBy,Integer.parseInt(numberOfResults),keywords);
			response.getOutputStream().print(poiCrit.toString());
			/*
			try {
				con = postgres.OpenConnection();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
					
			try {
				listOfPOIs = postgres.getPOIs(con, poiCrit);
			} catch (SQLException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			
			try {
				postgres.CloseConnection(con);
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
			
			if ( listOfPOIs != null ){
				if (msgChoice.equals("json")){
					msgResponse = "{\"poiList\":[";
			        for (int i = 0 ; i < listOfPOIs.size() ; i ++ ){
			            msgResponse = msgResponse +  listOfPOIs.get(i).toJson();
			        }
			        msgResponse = msgResponse + "]}";
				}
				else{
					msgResponse = "callback({\"poiList\":[";
			        for (int i = 0 ; i < listOfPOIs.size() ; i ++ ){
			            msgResponse = msgResponse +  listOfPOIs.get(i).toJson();
			        }
			        msgResponse = msgResponse + "]})";
				}
				
				
		        
			}
			else{
				if (msgChoice.equals("json")){
					msgResponse = "{\"poiList\":[]}";
				}
				else{
					msgResponse = "callback({\"poiList\":[]})";

				}
				
			}
			response.getOutputStream().print(msgResponse);*/
		}
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		
		}
	//}

}
