package postgres.poi;

import java.sql.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

import entites.Configuration;



public class PostgreSQLFunctions {
	Connection con = null;
    Statement st = null;
    ResultSet rs = null;
    String query = null;
    public static String CONF_LOCATION="/etc/modissenserc";
	
	private Configuration conf;
    
	
    public PostgreSQLFunctions(){
    }
    
    
    public Connection OpenConnection() throws SQLException{
        
    	
    	conf = new Configuration(CONF_LOCATION);
        
    	try {
            Class.forName("org.postgresql.Driver");
        } catch (ClassNotFoundException ex) {
            Logger.getLogger(PostgreSQLFunctions.class.getName()).log(Level.SEVERE, null, ex);
        }
        
        con = DriverManager.getConnection("jdbc:postgresql://"+
				this.conf.getValue("DATABASE_HOST")+":"+
				this.conf.getValue("DATABASE_PORT")+"/"+
				this.conf.getValue("DATABASE_NAME"),
				this.conf.getValue("DATABASE_USERNAME"),
				this.conf.getValue("DATABASE_PASSWORD"));
        if ( con == null){
            System.err.println("Connection Failed");
        }
        else{
            System.out.println("Connection Success");
        }
        return con;
    }
    
    
    public void CloseConnection( Connection con ) throws SQLException{
        if ( con != null ){
            con.close();
            System.out.println("Connection Close");
        }
        else{
            System.err.println("Connection does not exist");
        }
    }

    public ArrayList<String> SelectStatement( Connection con , String table ) throws SQLException{
        ArrayList <String> listUser = new ArrayList<String>();
        st = con.createStatement();
       
        query = "SELECT * FROM " + table + ";";
        System.out.println(query);
        rs = st.executeQuery("SELECT * FROM " + table);

        while (rs.next()) {
        	listUser.add(rs.getString(2));
        	//System.out.println(rs.getString(1));
        }
    	return listUser;
    }
    
    public boolean addNewPOIs(Connection con, ArrayList<PoiCharacteristics> listOfPOIs) throws SQLException{
        PoiCharacteristics poi;
        java.util.Date tmstamp= new java.util.Date();
        
        st = con.createStatement();
        for ( int i = 0 ; i < listOfPOIs.size() ; i ++ ){
            poi = listOfPOIs.get(i);
            if ( !findPOI(con,poi.getX(),poi.getY())){
                query = "INSERT INTO poi(name,coordinates,interest,hotness,publicity,keywords,description,tmstamp) VALUES ('" + poi.getName() + "',point'(" + poi.getX() + "," + poi.getY() + ")','" + poi.getInterest() + "','" + poi.getHotness() + "','" + poi.getPublicity() + "','" + poi.getKeywords() + "','" + poi.getDescription()  + "','" + tmstamp + "')";
                System.out.println(query);
                st.executeUpdate(query);
            }
        }
        
        return true;
    }
    
    
    public boolean findPOI(Connection con, double x , double y ) throws SQLException{
        st = con.createStatement();
        query = "SELECT * FROM poi WHERE coordinates[0] = '" + x +"' AND coordinates[1] = '" + y +"'" ;
        rs = st.executeQuery(query);
        while( rs.next()){
            return true;
        }
        return false;
    }
    
    //////////////////////////////////////////////////////////////////////////////////////////
    //logika tha prepei ektos apo ta vriskei ta duplicates na vazei kai to simeio stin vasi///
    //////////////////////////////////////////////////////////////////////////////////////////
    public ArrayList<PoiCharacteristics> findDuplicates( Connection con, double x, double y) throws SQLException{
        ArrayList<PoiCharacteristics> listOfPOIs = null;
        PoiCharacteristics poi;
        String name = null;
        int interest;
        int hotness;
        boolean publicity;
        String keywords = null;
        String description = null;
        Timestamp tmstamp = null;
        
        //////////////////////////////////////thelw na dw to ti tha kanw me ta keywords, tha ta pairnw i oxi???/////////////////////
        st = con.createStatement();
        query = "SELECT * FROM poi WHERE coordinates[0] = " + x +" and coordinates[1] = " + y + "";
        rs = st.executeQuery(query);
        if (rs.next()){
            name = rs.getString(2);
            interest = rs.getInt(4);
            hotness = rs.getInt(5);
            publicity = rs.getBoolean(6);
            keywords = rs.getString(7);
            description = rs.getString(8);
            tmstamp = rs.getTimestamp(9);
            listOfPOIs = new ArrayList<PoiCharacteristics>();
            poi = new PoiCharacteristics(name,x,y,interest,hotness,publicity,keywords,description,tmstamp);
            listOfPOIs.add(poi);
            while(rs.next()){
                name = rs.getString(2);
                interest = rs.getInt(4);
                hotness = rs.getInt(5);
                publicity = rs.getBoolean(6);
                keywords = rs.getString(7);
                description = rs.getString(8);
                tmstamp = rs.getTimestamp(9);
                poi = new PoiCharacteristics(name,x,y,interest,hotness,publicity,keywords,description,tmstamp);
                listOfPOIs.add(poi);
            }
        }
        else{
            return null;
        }
        
        return listOfPOIs;
    }
    
    public ArrayList<PoiCharacteristics> getPOIs(Connection con,PoiCriteria poiCrit) throws SQLException{
        String name;
        double x = 0,y = 0;
        int interest;
        int hotness;
        boolean publicity;
        String keywords = null;
        String description = null;
        Timestamp tmstamp = null;
        ArrayList<PoiCharacteristics>listOfPOIs;
        PoiCharacteristics poi ;
        boolean FLAG = false;
        
        st = con.createStatement();
        
        
        /*search in his own POIs*/
        if ( poiCrit.getFriendsList() == null ){
       
            query = "SELECT p.poi_id,p.name,p.coordinates[0],p.coordinates[1],p.hotness,p.publicity,p.interest,p.keywords,p.description,p.tmstamp  FROM poi p WHERE ";
            
            /*rectangle*/
            if ( poiCrit.getX1Region() != -1 && poiCrit.getY1Region() != -1 && poiCrit.getX2Region() != -1 && poiCrit.getY2Region() != -1 ){
                FLAG = true;
                query = query +" p.coordinates  <@ box(point'(" + poiCrit.getX1Region()+ "," + poiCrit.getY1Region() + ")',point'(" + poiCrit.getX2Region() + "," + poiCrit.getY2Region() + ")') ";
            }

            /*start time, end time*/
            if ( poiCrit.getStart_time() != null && poiCrit.getEnd_time() != null ){
                if (FLAG == true){
                    query = query + " and ";
                }
                FLAG = true;
                query = query + "p.poi_id IN ( SELECT poi_id FROM poi_list WHERE tmstamp >= '" + poiCrit.getEnd_time() + "' and tmstamp <= '" + poiCrit.getStart_time() + "')" ;
            }
            else if ( poiCrit.getStart_time() != null ){
                if (FLAG == true){
                    query = query + " and ";
                }
                FLAG = true;
                query = query + "p.poi_id IN ( SELECT poi_id FROM poi_list WHERE tmstamp >= '" + poiCrit.getStart_time() + "')" ;
            }
            else if ( poiCrit.getEnd_time() != null ){
                if (FLAG == true){
                    query = query + " and ";
                }
                FLAG = true;
                query = query + " p.poi_id IN (  SELECT poi_id FROM poi_list WHERE tmstamp <= '" + poiCrit.getEnd_time() + "') " ;
            }

            /*keywords*/
            if ( poiCrit.getKeywordsList() != null ){

                if (FLAG == true){
                    query = query + " and ";
                }
                query = query + "p.keywords LIKE '%" + poiCrit.getKeywordsList().get(0) + "%'";
                FLAG = true;
            }

            /*Order by*/
            if (poiCrit.getOrderBy() != null ){
                if (FLAG == true){
                    query = query + " ORDER BY " + poiCrit.getOrderBy() + " DESC";
                }
                FLAG = true;
            }

            /*number of resutls*/
            if (poiCrit.getNoOfResults() != -1 ){
                if (FLAG == true){
                    query = query + " LIMIT " + poiCrit.getNoOfResults();
                }
                FLAG = true;
            }
        }
        /*search his freinds POIs*/
        else{
            query = "SELECT DISTINCT(p.poi_id),p.name,p.coordinates[0],p.coordinates[1],p.hotness,p.publicity,p.interest,p.keywords,p.description,p.tmstamp FROM poi p WHERE ";
            
            /*find all POIs of his friends*/
            if ( poiCrit.getFriendsList() != null && poiCrit.getEnd_time() == null && poiCrit.getStart_time() == null ){
                query = query + " ( p.poi_id IN  ( SELECT pl.poi_id FROM poi_list pl , friends f WHERE f.usera = '" + poiCrit.getUser_id() + "' and f.userb = '" + poiCrit.getFriendsList().get(0) +"' and f.userb = pl.user_id )" ;
                for (int i = 1 ; i < poiCrit.getFriendsList().size() ; i ++ ){
                    System.out.println("friends = " + poiCrit.getFriendsList().get(i));
                    query = query + " or p.poi_id IN ( SELECT pl.poi_id FROM poi_list pl , friends f WHERE f.usera = '" + poiCrit.getUser_id() + "' and f.userb = '" + poiCrit.getFriendsList().get(i) +"' and f.userb = pl.user_id )" ;
                }
                query = query + ")";
                FLAG = true;
            }
            
            else{
                /*start time, end time*/
                if ( poiCrit.getStart_time() != null && poiCrit.getEnd_time() != null ){
                    if (FLAG == true){
                        query = query + " and ";
                    }
                    FLAG = true;
                    query = query + " ( p.poi_id IN  ( SELECT pl.poi_id FROM poi_list pl , friends f WHERE f.usera = '" + poiCrit.getUser_id() + "' and f.userb = '" + poiCrit.getFriendsList().get(0) + "' and f.userb = pl.user_id and pl.tmstamp >= '" + poiCrit.getEnd_time() + "' and pl.tmstamp <= '" + poiCrit.getStart_time() + "')";
                    for (int i = 1 ; i < poiCrit.getFriendsList().size() ; i ++ ){
                        System.out.println("friends = " + poiCrit.getFriendsList().get(i));
                        query = query + " or p.poi_id IN ( SELECT pl.poi_id FROM poi_list pl , friends f WHERE f.usera = '" + poiCrit.getUser_id() + "' and f.userb = '" + poiCrit.getFriendsList().get(i) +"' and f.userb = pl.user_id and pl.tmstamp >= '" + poiCrit.getEnd_time() + "' and pl.tmstamp <= '" + poiCrit.getStart_time() + "')";
                    }
                   // query = query +  " p.poi_id IN ( select poi_id from poi_list where tmstamp >= '" + poiCrit.getEnd_time() + "' and tmstamp <= '" + poiCrit.getStart_time() + "')" ;
                    query = query + ")";
                }
                else if ( poiCrit.getStart_time() != null ){
                    if (FLAG == true){
                        query = query + " and ";
                    }
                    FLAG = true;
                    query = query + " ( p.poi_id IN  ( SELECT pl.poi_id FROM poi_list pl , friends f WHERE f.usera = '" + poiCrit.getUser_id() + "' and f.userb = '" + poiCrit.getFriendsList().get(0) + "' and f.userb = pl.user_id and pl.tmstamp >= '" + poiCrit.getStart_time() + "')";
                    for (int i = 1 ; i < poiCrit.getFriendsList().size() ; i ++ ){
                        System.out.println("friends = " + poiCrit.getFriendsList().get(i));
                        query = query + " or p.poi_id IN ( SELECT pl.poi_id FROM poi_list pl , friends f WHERE f.usera = '" + poiCrit.getUser_id() + "' and f.userb = '" + poiCrit.getFriendsList().get(i) +"' and f.userb = pl.user_id and pl.tmstamp >= '" + poiCrit.getStart_time() + "')";
                    }
                    //query = query + "pl.poi_id IN ( select poi_id from poi_list where tmstamp >= '" + poiCrit.getStart_time() + "')" ;
                    query = query + ")";
                }
                else if ( poiCrit.getEnd_time() != null ){
                    if (FLAG == true){
                        query = query + " and ";
                    }
                    FLAG = true;
                    query = query + " ( p.poi_id IN  ( SELECT pl.poi_id FROM poi_list pl , friends f WHERE f.usera = '" + poiCrit.getUser_id() + "' and f.userb = '" + poiCrit.getFriendsList().get(0) + "' and f.userb = pl.user_id and pl.tmstamp <= '" + poiCrit.getEnd_time() + "') ";
                    for (int i = 1 ; i < poiCrit.getFriendsList().size() ; i ++ ){
                        System.out.println("friends = " + poiCrit.getFriendsList().get(i));
                        query = query + " or p.poi_id IN ( SELECT pl.poi_id FROM poi_list pl , friends f WHERE f.usera = '" + poiCrit.getUser_id() + "' and f.userb = '" + poiCrit.getFriendsList().get(i) +"' and f.userb = pl.user_id and pl.tmstamp <= '" + poiCrit.getEnd_time() + "')" ;
                    }
                    //query = query + " u.user_id = '" + poiCrit.getUser_id() + "' and u.user_id = pl.user_id and pl.poi_id IN (  select poi_id from poi_list where tmstamp <= '" + poiCrit.getEnd_time() + "') " ;
                    query = query + ")";
                }
            }

            /*rectangle*/
            if ( poiCrit.getX1Region() != -1 && poiCrit.getY1Region() != -1 && poiCrit.getX2Region() != -1 && poiCrit.getY2Region() != -1 ){
                if (FLAG == true){
                    query = query + " and ";
                }
                FLAG = true;
                query = query + " p.coordinates  <@ box(point'(" + poiCrit.getX1Region()+ "," + poiCrit.getY1Region() + ")',point'(" + poiCrit.getX2Region() + "," + poiCrit.getY2Region() + ")') ";
            }
           
            /*keywords*/
            if ( poiCrit.getKeywordsList() != null ){

                if (FLAG == true){
                    query = query + " and ";
                }
                query = query + "p.keywords   LIKE '%" + poiCrit.getKeywordsList().get(0) + "%'";
                FLAG = true;
            }
            

            /*Order by*/
            if (poiCrit.getOrderBy() != null ){
                if (FLAG == true){
                    query = query + " ORDER BY " + poiCrit.getOrderBy() + " DESC";
                }
                FLAG = true;
            }

            /*number of resutls*/
            if (poiCrit.getNoOfResults() != -1 ){
                if (FLAG == true){
                    query = query + " LIMIT " + poiCrit.getNoOfResults();
                }
                FLAG = true;
            }
 
        }
        
        query = query + ";";
       
        System.out.println("query = " + query);
        
        rs = st.executeQuery(query);
        if (rs.next()){
            name = rs.getString(2);
            x = rs.getDouble(3);
            y = rs.getDouble(4);
            hotness = rs.getInt(5);
            publicity = rs.getBoolean(6);
            interest = rs.getInt(7);
            keywords = rs.getString(8);
            description = rs.getString(9);
            tmstamp = rs.getTimestamp(10);
            listOfPOIs = new ArrayList<PoiCharacteristics>();
            poi = new PoiCharacteristics(name,x,y,interest,hotness,publicity,keywords,description,tmstamp);
            listOfPOIs.add(poi);
            while(rs.next()){
                name = rs.getString(2);
                x = rs.getDouble(3);
                y = rs.getDouble(4);
                hotness = rs.getInt(5);
                publicity = rs.getBoolean(6);
                interest = rs.getInt(7);
                keywords = rs.getString(8);
                description = rs.getString(9);
                tmstamp = rs.getTimestamp(10);
                poi = new PoiCharacteristics(name,x,y,interest,hotness,publicity,keywords,description,tmstamp);
                listOfPOIs.add(poi);
            }
        }
        else{
            return null;
        }
        
        return listOfPOIs;
    }
    
    
    public ArrayList<PoiCharacteristics> filterUnique(Connection con,ArrayList<PoiCharacteristics> POIList) throws SQLException{
        int i,j;
        PoiCharacteristics poi;
        ArrayList <PoiCharacteristics> PoiNotExistList = null;
        String del = ",";
        String[] temp;
        boolean FLAG = false;
        
        
        st = con.createStatement();
        for ( i = 0 ; i < POIList.size() ; i ++ ){
            poi = POIList.get(i);
            query = "SELECT * FROM poi p WHERE p.coordinates[0] = " + poi.getX() +" and p.coordinates[1] = " + poi.getY();
            if ( poi.getKeywords() != null ){
                temp = poi.getKeywords().split(del);
                query = query + " and  p.poi_id in (SELECT pl.poi_id FROM poi_other_characteristics pl WHERE pl.property_name = '" + temp[0] +"'" ;
                for ( j = 1 ; j < temp.length ; j ++ ){
                    query = query + " and pl.poi_id in( SELECT pl.poi_id FROM poi_other_characteristics pl WHERE pl.property_name = '" + temp[j] + "')";
                }
                query = query + ")";
            }      
            query = query + ";";
            System.out.println("query = " + query);
            rs = st.executeQuery(query);
            if(rs.next()){
               
            }
            else{
                 if (FLAG == false){
                    FLAG = true;
                    PoiNotExistList = new ArrayList<PoiCharacteristics>();
                }

                PoiNotExistList.add(poi);
            }          
        }
        
        return PoiNotExistList; 
    
    }
    
    
    public ArrayList<PoiCharacteristics> getNN(Connection con,PoiCharacteristics centralPOI, int k) throws SQLException{
        ArrayList <PoiCharacteristics> neighboorhoodPOIs = null;
        PoiCharacteristics poi ;
        Boolean FLAG = false;
        String name;
        double x = 0,y = 0;
        int interest;
        int hotness;
        boolean publicity;
        String keywords = null;
        String description = null;
        Timestamp tmstamp = null;
        
        st = con.createStatement();
        query = "SELECT p.name,p.coordinates[0], p.coordinates[1], p.interest, p.hotness, p.publicity, p.keywords, p.description, p.tmstamp FROM poi p ORDER BY p.coordinates <-> point('" + centralPOI.getX() + "','" + centralPOI.getY() + "') LIMIT " + k;
        
        System.out.println("query = " + query);
        rs = st.executeQuery(query);
        
        while(rs.next()){
            if (FLAG == false){
                FLAG = true;
                neighboorhoodPOIs = new ArrayList<PoiCharacteristics>();
            }
            System.out.println(rs.getString(1));
            name = rs.getString(1);
            x = rs.getDouble(2);
            y = rs.getDouble(3);
            interest = rs.getInt(4);
            hotness = rs.getInt(5);
            publicity = rs.getBoolean(6);
            keywords = rs.getString(7);
            description = rs.getString(8);
            tmstamp = rs.getTimestamp(9);
            poi = new PoiCharacteristics(name,x,y,interest,hotness,publicity,keywords,description,tmstamp);
            neighboorhoodPOIs.add(poi);
        }

        return neighboorhoodPOIs;
    }
    
    
    public boolean updatePOIInterest(){
    
        return true;
    }
    
    
    public boolean updatePOI(int user_id, PoiCharacteristics poi){
    
        return true;
    }
    
}
