package postgres.poi;

import java.sql.Timestamp;
import java.util.ArrayList;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PoiCharacteristics {
    private String name = null;
    private double x = -1;
    private double y = -1;
    private int interest = -1;
    private int hotness = -1;
    private boolean publicity = true;
    private String keywords = null;
    private String description = null;
    private Timestamp tmstamp = null;
    private ArrayList <String> keywordsList = null;
    //private String property_name;
    //private String property_value;

    

    
   
    public PoiCharacteristics(String name, double x , double y, int interest, int hotness, boolean publicity, String keywords, String description, Timestamp tmstamp){
        this.name = name;
        this.x = x;
        this.y = y;
        this.interest = interest;
        this.hotness = hotness;
        this.publicity = publicity;
        this.keywords = keywords;
        if ( keywords != null ){
            keywordsList = new ArrayList<String>();
            if (keywords.contains(",")){
                String []temp;
                temp = keywords.split(",");
                if ( temp.length != 0 ){
                    for (int i = 0; i < temp.length ; i++ ){
                        keywordsList.add(temp[i]);
                    }
                }
            }
            else{
                keywordsList.add(keywords);
            }
        }
        else{
            keywordsList = null;
        }
        this.description = description;
        this.tmstamp = tmstamp;
        
    }
    
    
    public String toJson(){
    	String msgJson = null;
    	String strKeywords = null;
    	if ( keywordsList != null ){
    		strKeywords = "[\"" + keywordsList.get(0) +"\"";
    		for ( int i = 1 ; i < keywordsList.size() ; i++ ){
    			strKeywords = strKeywords + ",\"" + keywordsList.get(i) + "\"";
    		}
    		strKeywords = strKeywords + "]";
    	}
    	msgJson = "{\"name\":\"" + name + "\",\"x\":" + x + ", \"y\":" + y + ",\"interest\":" + interest + ",\"hotness\":" + hotness + ",\"publicity\":" + publicity + ",\"keywords\":\"" + strKeywords + "\",\"description\":\"" + description + "\"}";	
    	return msgJson;
    }
    
    
    public String toString(){
        String str = null;
       
        str = name + "," + x + "," + y + "," + interest + "," + hotness + "," + publicity + "," + keywords ;
        
        return str;
    }
    
    /////////////////////set/////////////////////////
    
    public void setName(String poi_id) {
        this.name = poi_id;
    }

    
    public void setX(double x) {
        this.x = x;
    }

    
    public void setY(double y) {
        this.y = y;
    }

    
    public void setInterest(int interest) {
        this.interest = interest;
    }

    
    public void setHotness(int hotness) {
        this.hotness = hotness;
    }

    
    public void setPublicity(boolean publicity) {
        this.publicity = publicity;
    }
    
    public void setKeywords (String keywords){
        this.keywords = keywords;
    }
    
    public void setDescription(String description) {
        this.description = description;
    }

    public void setTmstamp(Timestamp tmstamp) {
        this.tmstamp = tmstamp;
    }


    ////////////////////////////get//////////////////////
    
    public String getName() {
        return name;
    }

    
    public double getX() {
        return x;
    }

    
    public double getY() {
        return y;
    }

    
    public int getInterest() {
        return interest;
    }

    
    public int getHotness() {
        return hotness;
    }

    
    public boolean getPublicity() {
        return publicity;
    }

    
    public String getKeywords(){
        return keywords;
    }
        
    public String getDescription() {
        return description;
    }

    public Timestamp getTmstamp() {
        return tmstamp;
    }

}
