package services.poi;

import java.io.BufferedReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import postgres.poi.PoiCharacteristics;
import postgres.poi.PostgreSQLFunctions;

import description.HTMLDescription;
import description.ServiceDescription;

/**
 * Servlet implementation class AddNewPOIs
 */
@WebServlet("/AddNewPOIs")
public class AddNewPOIs extends HttpServlet {
	private static final long serialVersionUID = 1L;
	private ServiceDescription description;
       
    /**
     * @see HttpServlet#HttpServlet()
     */
    public AddNewPOIs() {
        super();
        this.description = new HTMLDescription("Add new POIs");
        this.description.addParameter("List Of POI objects", "POIList");
        this.description.setReturnValue("boolean");
        this.description.setDescription("Web service used to add a list of POIs");
        // TODO Auto-generated constructor stub
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		if(request.getParameter("info")!=null){
			response.getOutputStream().print(this.description.serialize());
		} 
		/*else if(request.getParameter("POIList")==null){
			response.sendError(HttpServletResponse.SC_BAD_REQUEST);
		}*/ 
		else {
			PostgreSQLFunctions postgres = new PostgreSQLFunctions();
			ArrayList<PoiCharacteristics> listOfPOIs = new ArrayList<PoiCharacteristics>();
			Connection con = null;
			boolean result = false;
			
			

			String name = request.getParameter("name");
			String x = request.getParameter("x");
			String y = request.getParameter("y");
			int interest = -1; 
			int hotness =  -1;
			String publicity = request.getParameter("publicity");
			String keywords = request.getParameter("keywords");
			String description = request.getParameter("description");
			String msgChoice = request.getParameter("format");
			
			
			String msgResponse = null;
			
			PoiCharacteristics poiChar = new PoiCharacteristics(name,Double.parseDouble(x),Double.parseDouble(y),interest,hotness,Boolean.getBoolean(publicity),keywords,description,null);
			listOfPOIs.add(poiChar);
			
			
			try {
				con = postgres.OpenConnection();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
			try {
				result = postgres.addNewPOIs(con, listOfPOIs);
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
			try {
				postgres.CloseConnection(con);
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		
			if (msgChoice.equals("json")){		
				msgResponse = "{\"result\":\"" + result + "\"}";
			}
			else{
				msgResponse = "callback({\"result\":\"" + result + "\"})";
			}
			response.setContentType("application/json;charset=ISO-8859-1");
			response.getOutputStream().print(msgResponse);
		}
		
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
	}

}
