package services.poi;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import description.HTMLDescription;
import description.ServiceDescription;

/**
 * Servlet implementation class UpdateSemanticTrajectories
 */
@WebServlet("/UpdateSemanticTrajectories")
public class UpdateSemanticTrajectories extends HttpServlet {
	private static final long serialVersionUID = 1L;
	private ServiceDescription description;
       
    /**
     * @see HttpServlet#HttpServlet()
     */
    public UpdateSemanticTrajectories() {
        super();
        this.description = new HTMLDescription("Update Semantic Trajectories");
        this.description.addParameter("String", "UserID");
        this.description.addParameter("Semantic Trajectory", "UpdateTrajectory");
        this.description.setReturnValue("boolean");
        this.description.setDescription("Web service updates semantic trajectories");
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		if(request.getParameter("info")!=null){
			response.getOutputStream().print(this.description.serialize());
		} else if ( (request.getParameter("UserID")==null) || (request.getParameter("UpdateTrajectory")==null) ) {
			response.sendError(HttpServletResponse.SC_BAD_REQUEST);
		} else {
			response.getOutputStream().print(true);
		}
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
	}

}
