package services.users;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.net.ssl.HttpsURLConnection;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

import session.SessionManagementIM;
import supportingClasses.Utils;
import twitter4j.PagableResponseList;
import twitter4j.Twitter;
import twitter4j.TwitterFactory;
import twitter4j.TwitterException;
import twitter4j.conf.ConfigurationBuilder;

import description.HTMLDescription;
import description.ServiceDescription;
import entites.SNDetails;
import entites.User;
import fi.foyt.foursquare.api.FoursquareApi;
import fi.foyt.foursquare.api.FoursquareApiException;
import fi.foyt.foursquare.api.Result;
import fi.foyt.foursquare.api.entities.CompactUser;
import fi.foyt.foursquare.api.entities.CompleteUser;
import fi.foyt.foursquare.api.entities.UserGroup;
import fi.foyt.foursquare.api.entities.UserGroups;

/**
 * Servlet implementation class UserInfo
 * returns a modissense userObject in json format
 * 
 * @author Giagkos Mytilinis
 */

@WebServlet("/UserInfo")
public class UserInfo extends HttpServlet {
	private static final long serialVersionUID = 1L;
	private ServiceDescription description;
	
    /**
     * @see HttpServlet#HttpServlet()
     */
    public UserInfo() {
        super();
        this.description = new HTMLDescription("Get User Object");
        this.description.addParameter("String", "token");
        this.description.setReturnValue("json");
        this.description.setDescription("Web service used to get the object of a user");
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		if(request.getParameter("info")!=null){
			response.getOutputStream().print(this.description.serialize());
		} else if(request.getParameter("token")==null){
			response.sendError(HttpServletResponse.SC_BAD_REQUEST);
		} else {
			
			HttpSession session = request.getSession();
			String token = (String) request.getParameter("token");
			
			System.out.println("token = "+token);
			
			int usid = SessionManagementIM.getUser(token);
			
			System.out.println("uid = "+usid);
			String jsonToSend = "{\"user\":{\"username\":\"";
			
			User loggedInUser = new User();
			loggedInUser.setId(usid);
			List<HashMap<String, String>> userInfo = loggedInUser.read();
			if(userInfo.size()==1){
				jsonToSend+=userInfo.get(0).get("username")+"\",\"connections\":[";
			}else{
				System.out.println("ERROR: strange error on UserInfo");
			}
			
			SNDetails loggedInUserSN = new SNDetails();
			loggedInUserSN.setUserId(usid);
			
			List<HashMap<String, String>> results = loggedInUserSN.read();
			int rSize= results.size();
			
			
		
			for(int i=0;i<rSize;i++){
				
				if(results.get(i).get("sn_name").equals("twitter")){
					
					ConfigurationBuilder userConfBuilder = new ConfigurationBuilder();
					userConfBuilder.setDebugEnabled(true)
					  .setOAuthConsumerKey("xJkcRYwkcyfi6H7cc25JNQ")
					  .setOAuthConsumerSecret("dzo4wR2zBn1gbhFgxhhFVcZHVe8UKMS4VwL1FqI0Cgk")
					  .setOAuthAccessToken(results.get(i).get("sn_token"))
					  .setOAuthAccessTokenSecret(results.get(i).get("sn_token_secret"))
					  .setIncludeEntitiesEnabled(true);
					
					TwitterFactory tf = new TwitterFactory(userConfBuilder.build());
					Twitter userTwitter = tf.getInstance ();
					
					jsonToSend+="{\"network\":\"twitter\",\"friends\":[";
					long cursor=-1;
					do{
						try {
							PagableResponseList<twitter4j.User> userFollowers = userTwitter.getFollowersList(userTwitter.getScreenName(),cursor);
							System.out.println("cursor: "+cursor);
							for(twitter4j.User follower:userFollowers){
								System.out.println("phra user");
								jsonToSend+="{\"id\":\""+follower.getId()+"\",\"name\":\""+follower.getScreenName()+"\"}";
							}
							cursor = userFollowers.getNextCursor();
						} catch (TwitterException e) {
							e.printStackTrace();
						}
					}while(cursor!=0);
					jsonToSend = jsonToSend.replaceAll("\\}\\{", "},{");
					jsonToSend+="]}";
					
				}else if(results.get(i).get("sn_name").equals("facebook")){
					
					jsonToSend+="{\"network\":\"facebook\",\"friends\":[";
					
					URL url = new URL("https://graph.facebook.com/"+results.get(i).get("sn_identifier")+"/friends?access_token="+results.get(i).
							get("sn_token"));
					HttpsURLConnection conn =(HttpsURLConnection) url.openConnection();conn.setRequestMethod("GET");
					conn.setDoOutput(true);
				     
				    StringBuffer answer = new StringBuffer();
				    BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
				    String line;
				    
				     while ((line = reader.readLine()) != null) {
				            answer.append(line);
				     }
				     reader.close();
				    
				     String userAnswer = answer.toString();
				     
				     JSONObject userObj =(JSONObject) JSONValue.parse(userAnswer);
				     JSONArray data = (JSONArray) userObj.get("data");
				     
				     Iterator<JSONObject> jsonArrayIterator = (Iterator<JSONObject>) data.iterator();
				     
				     while(jsonArrayIterator.hasNext()){
				    	 JSONObject nextFriend = jsonArrayIterator.next();
				    	 jsonToSend+="{\"id\":\""+(String) nextFriend.get("id")+"\",\"name\":\"" +
				    	 		(String) nextFriend.get("name")+"\"}";
				     }
				     
				     jsonToSend = jsonToSend.replaceAll("\\}\\{", "},{");
				     jsonToSend+="]}";
				}else{
					
					jsonToSend+="{\"network\":\"foursquare\",\"friends\":[";
					
					String clientId = "PJB10MU45PJUL3VBHFCT4U33TNWY3C0S00TZ4SQE0QYHXWNM";
					String clientSecret = "YOCYLYFQ0M0PFUJIAEF5F25OTDYOEAFLU1GNMXRUVXQIPUG0";
					String callback= "https://snf-97398.vm.okeanos.grnet.gr/rest/users/fsqcallback";
					
			        FoursquareApi foursquareApi = new FoursquareApi(clientId,clientSecret,callback);
			        foursquareApi.setoAuthToken(results.get(i).get("sn_token"));
			        
			        Result<CompleteUser> result;
					try {
						result = foursquareApi.user("self");
						if (result.getMeta().getCode() == 200) {
			                  CompleteUser fUser = result.getResult();
			                  UserGroups friendsGroups = fUser.getFriends();
			                  UserGroup[] friendGroupArray = friendsGroups.getGroups();
			                  for(int j=0;j<friendGroupArray.length;j++){
			                	  CompactUser[] friends = friendGroupArray[j].getItems();
			                	  for(CompactUser myfriend:friends){
			                		  jsonToSend+="{\"id\":\""+myfriend.getId()+"\",\"name\":\"" +
			  				    	 		myfriend.getFirstName()+" "+myfriend.getLastName()+"\"}";
			                	  }
			                  }
			                  jsonToSend = jsonToSend.replaceAll("\\}\\{", "},{");
							  jsonToSend+="]}";
			              }
			              else {
			            	  jsonToSend+="]}";
			                  System.out.println("Error occured: ");
			                  System.out.println("  code: " + result.getMeta().getCode());
			                  System.out.println("  type: " + result.getMeta().getErrorType());
			                  System.out.println("  detail: " + result.getMeta().getErrorDetail());
			              }
					} catch (FoursquareApiException e) {
						e.printStackTrace();
					}
		              
					
				}
				
			}
			
			jsonToSend+="]}}";
			response.setHeader("Content-Type", "application/json");
			response.setHeader("charset", "utf-8");
			PrintWriter out = response.getWriter();
			
			String format = request.getParameter("format");
			if(format.equals("jsonp"))
				out.write("callback("+jsonToSend+")");
			else if(format.equals("json"))
				out.write(jsonToSend);
			
		} 
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// does nothing for now
	}

}
