package services.users;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import supportingClasses.OAuth;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;

import twitter4j.auth.RequestToken;
import twitter4j.conf.ConfigurationBuilder;

import description.HTMLDescription;
import description.ServiceDescription;
import fi.foyt.foursquare.api.FoursquareApi;

/**
 * Servlet implementation class Register
 *
 * 
 * 
 * @author Giagkos Mytilinis
 *
 */

@WebServlet("/Register")
public class Register extends HttpServlet {
	private static final long serialVersionUID = 1L;
	private ServiceDescription description;
	
    /**
     * @see HttpServlet#HttpServlet()
     */
    public Register() {
        super();
        description = new HTMLDescription("User Register");
        description.addParameter("String", "userid");
        description.addParameter("String", "network");
        description.addParameter("String", "callback");
        description.setReturnValue("boolean");
        description.setDescription("This service is used to register a user to the ModisSense platform.");   
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		if(request.getParameter("info")!=null){
			response.getOutputStream().print(this.description.serialize());
		} else if(request.getParameter("token")==null || request.getParameter("network")==null || request.getParameter("callback")==null){
			response.sendError(HttpServletResponse.SC_BAD_REQUEST);
		} else {
			
			String userID = request.getParameter("token");
			String socialNetwork = request.getParameter("network");
			String callbackURL = request.getParameter("callback");
			
			HttpSession session = request.getSession();
			
			session.setAttribute("uidtoken",userID);
			session.setAttribute("callback", callbackURL);
			session.setAttribute("network", socialNetwork);
			
			if(socialNetwork.equals("twitter")){
				ConfigurationBuilder cb = new ConfigurationBuilder();
				cb.setDebugEnabled(true)
				  .setIncludeEntitiesEnabled(true)
				  .setUseSSL(true);
				
				Twitter twitter = new TwitterFactory(cb.build()).getInstance();
				
				twitter.setOAuthConsumer("xJkcRYwkcyfi6H7cc25JNQ", "dzo4wR2zBn1gbhFgxhhFVcZHVe8UKMS4VwL1FqI0Cgk");
				
				try {
					RequestToken twitterRequestToken = twitter.getOAuthRequestToken();
					String token = twitterRequestToken.getToken();
					String tokenSecret = twitterRequestToken.getTokenSecret();
						
					session.setAttribute("token", token);
					session.setAttribute("tokenSecret", tokenSecret);
					session.setAttribute("twitter", false);
						
					String authUrl = twitterRequestToken.getAuthorizationURL();
						
					response.sendRedirect(authUrl);

				} catch (TwitterException e) {
					e.printStackTrace();
				}
				
				
			}else if(socialNetwork.equals("foursquare")){
				
				String clientId = "PJB10MU45PJUL3VBHFCT4U33TNWY3C0S00TZ4SQE0QYHXWNM";
				String clientSecret = "YOCYLYFQ0M0PFUJIAEF5F25OTDYOEAFLU1GNMXRUVXQIPUG0";
				String callback= "https://snf-97398.vm.okeanos.grnet.gr/rest/users/fsqcallback";
				
				try{
					FoursquareApi foursquareApi = new FoursquareApi(clientId,clientSecret,callback);
					response.sendRedirect(foursquareApi.getAuthenticationUrl());
				}catch(Exception e){
						e.printStackTrace();
				}
				
			}else if(socialNetwork.equals("facebook")){
					 String appID = "164541643735115";
					 String redirect_uri = "https://snf-97398.vm.okeanos.grnet.gr/rest/users/fbcallback";
					 String code = request.getParameter("code");
					 
					 if(code==null){
						 SecureRandom random = new SecureRandom();
					     String state = (new BigInteger(130, random).toString(32));
						 session.setAttribute("state", state);
						 
						 String permissions = "read_friendlists,read_stream,publish_actions";
						 //permissions+=",read_mailbox";
						 
						 response.sendRedirect("https://www.facebook.com/dialog/oauth?client_id="+appID+"&redirect_uri="+
								 OAuth.percentEncode(redirect_uri)+"&state="+state+"&scope="+permissions);
					 }
					
			}
					
		}
			
			
		
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

	}

}
