package supportingClasses;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.List;

import javax.net.ssl.HttpsURLConnection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

import session.SessionManagementIM;

import entites.SNDetails;
import entites.User;

/**
 * 
 * Servlet implementation class CallbackServlet
 * 
 * @author Giagkos Mytilinis
 */

public class FbCallback extends HttpServlet {
	
	private static final long serialVersionUID = 1L;
    
    /**
     * @see HttpServlet#HttpServlet()
     */
    public FbCallback() {
        super();
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
		HttpSession session = request.getSession();
		
		String appID = "164541643735115";
		String appSecret = "e78597ea2647e6d52a35b8a4e6034be0";
		String redirect_uri = "https://snf-97398.vm.okeanos.grnet.gr/rest/users/fbcallback";
		String code = request.getParameter("code");
	
		if(((String) session.getAttribute("state")).equals(request.getParameter("state"))){
			 if(request.getParameter("error")!=null){
				 System.out.println("The user denied to authorize your app");
				 System.out.println(request.getParameter("error_reason"));
				 System.out.println(request.getParameter("error"));
				 System.out.println(request.getParameter("error_description"));
			 }else{
				 URL url = new URL("https://graph.facebook.com/oauth/access_token?client_id="+appID+"&" +
							"redirect_uri="+OAuth.percentEncode(redirect_uri)+"&client_secret="+appSecret +
							"&code="+code);
				 HttpsURLConnection conn =(HttpsURLConnection) url.openConnection();conn.setRequestMethod("GET");
				 conn.setDoOutput(true);
			     
			     StringBuffer answer = new StringBuffer();
			     BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
			     String line;
			     while ((line = reader.readLine()) != null) {
			            answer.append(line);
			     }
			     reader.close();
			   
			     String accessAnswer = answer.toString();
			     String [] answerParts = accessAnswer.split("=");
			     String accessToken = answerParts[1];
			     
			     System.out.println("fb access token = "+accessToken);
			     url = new URL("https://graph.facebook.com/me?access_token="+accessToken);
				 conn =(HttpsURLConnection) url.openConnection();conn.setRequestMethod("GET");
				 conn.setDoOutput(true);
			     
			     answer = new StringBuffer();
			     reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
			     
			     while ((line = reader.readLine()) != null) {
			            answer.append(line);
			     }
			     reader.close();
			    
			     String userAnswer = answer.toString();
			     
			     JSONObject userObj =(JSONObject) JSONValue.parse(userAnswer);
			     String userId = (String) userObj.get("id");
			     String username = (String) userObj.get("username");
			     
			     SNDetails socialNetworkInfo = new SNDetails();
				 socialNetworkInfo.setSnName("facebook");
				 socialNetworkInfo.setSnIdentifier(userId);
					
				 List<HashMap<String, String>> results = socialNetworkInfo.read();
				 String token = null;
					
					if(results.size()==0){
						
						socialNetworkInfo.setSnToken(accessToken);
						
						System.out.println((String)session.getAttribute("uidtoken"));
						if(!((String)session.getAttribute("uidtoken")).equals("null")){
					
							System.out.println("step2");
							token = (String) session.getAttribute("uidtoken");
							System.out.println(token);
							
							int usid = SessionManagementIM.getUser(token);
							
							socialNetworkInfo.setUserId(usid);
							if(socialNetworkInfo.create()){
								System.out.println("sn_list entry created successfully.");
							}
							else
								System.out.println("sn_list entry failed");
						}else{
							System.out.println("ftiaxnw neo user");
							User newUser = new User();
							newUser.setUsername(username);
							if(newUser.create()){
								System.out.println("user entry created successfully.");
								User theSameUser = new User(username);
								socialNetworkInfo.setUserId(theSameUser.getId());			
								
								token = Utils.randomStringGenerator(32); 

								SessionManagementIM.addToSession(token, theSameUser.getId());
									
								if(socialNetworkInfo.create()){
									System.out.println("sn_list entry created successfully.");
								}
								else
									System.out.println("sn_list entry failed");
							}
							else
								System.out.println("user entry failed.");
						}
					} else{
					
						if(!SessionManagementIM.containsUser(socialNetworkInfo.getUserId())){
							
							token = Utils.randomStringGenerator(32); 
							SessionManagementIM.addToSession(token, socialNetworkInfo.getUserId());
							
						}else{
							token=SessionManagementIM.getSession(socialNetworkInfo.getUserId());
						}
					}
					
				 
				 response.sendRedirect(response.encodeRedirectURL((String)session.getAttribute("callback")+"&uid="+token));
			     
			 }
		}
	
		
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
	}

}

