package supportingClasses;

import java.io.IOException;

import java.util.HashMap;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import session.SessionManagementIM;


import entites.SNDetails;
import entites.User;
import fi.foyt.foursquare.api.FoursquareApi;
import fi.foyt.foursquare.api.FoursquareApiException;
import fi.foyt.foursquare.api.Result;
import fi.foyt.foursquare.api.entities.CompleteUser;

/**
 * Servlet implementation class CallbackServlet
 * 
 * @author Giagkos Mytilinis
 */

public class FoursquareCallback extends HttpServlet {
	
private static final long serialVersionUID = 1L;
    
    /**
     * @see HttpServlet#HttpServlet()
     */
    public FoursquareCallback() {
        super();
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
		String clientId = "PJB10MU45PJUL3VBHFCT4U33TNWY3C0S00TZ4SQE0QYHXWNM";
		String clientSecret = "YOCYLYFQ0M0PFUJIAEF5F25OTDYOEAFLU1GNMXRUVXQIPUG0";
		String callback= "https://snf-97398.vm.okeanos.grnet.gr/rest/users/fsqcallback";
		
        FoursquareApi foursquareApi = new FoursquareApi(clientId,clientSecret,callback);

        String code=request.getParameter("code");

        HttpSession session = request.getSession();
        
        try {

              foursquareApi.authenticateCode(code);
              String accessToken = foursquareApi.getOAuthToken();
               
              Result<CompleteUser> result = foursquareApi.user("self");
              if (result.getMeta().getCode() == 200) {
                  CompleteUser fUser = result.getResult();
                  System.out.println(fUser.getId());

                  SNDetails socialNetworkInfo = new SNDetails();
      			socialNetworkInfo.setSnName("foursquare");
      			socialNetworkInfo.setSnIdentifier(fUser.getId());
      			    			
      			List<HashMap<String, String>> results = socialNetworkInfo.read();
      			

    			String token = null;
    			
    			if(results.size()==0){
    				
    				socialNetworkInfo.setSnToken(accessToken);
    				
    				System.out.println((String)session.getAttribute("uidtoken"));
    				if(!((String)session.getAttribute("uidtoken")).equals("null")){
    			
    					System.out.println("step2");
    					token = (String) session.getAttribute("uidtoken");
    					System.out.println(token);
    					
    					int usid = SessionManagementIM.getUser(token);
    					
    					socialNetworkInfo.setUserId(usid);
    					if(socialNetworkInfo.create()){
    						System.out.println("sn_list entry created successfully.");
    					}
    					else
    						System.out.println("sn_list entry failed");
    				}else{
    					System.out.println("ftiaxnw neo user");
    					User newUser = new User();
    					newUser.setUsername(fUser.getFirstName()+fUser.getLastName());
    					if(newUser.create()){
    						System.out.println("user entry created successfully.");
    						User theSameUser = new User(fUser.getFirstName()+fUser.getLastName());
    						socialNetworkInfo.setUserId(theSameUser.getId());
    						
    						token = Utils.randomStringGenerator(32); 
    						SessionManagementIM.addToSession(token, theSameUser.getId());
    						
    						if(socialNetworkInfo.create()){
    							System.out.println("sn_list entry created successfully.");
    						}
    						else
    							System.out.println("sn_list entry failed");
    					}
    					else
    						System.out.println("user entry failed.");
    				}
    			} else{
    				
    				if(!SessionManagementIM.containsUser(socialNetworkInfo.getUserId())){
						
    					token = Utils.randomStringGenerator(32); 
    					SessionManagementIM.addToSession(token, socialNetworkInfo.getUserId());
						
					}else{
						token=SessionManagementIM.getSession(socialNetworkInfo.getUserId());
					}
    			}
    			
    			response.sendRedirect(response.encodeRedirectURL((String)session.getAttribute("callback")+"&uid="+token));

              }
              else {
                  System.out.println("Error occured: ");
                  System.out.println("  code: " + result.getMeta().getCode());
                  System.out.println("  type: " + result.getMeta().getErrorType());
                  System.out.println("  detail: " + result.getMeta().getErrorDetail());
              }
              
        } catch (FoursquareApiException e) {
              e.printStackTrace();
        }		
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
	}

}
