package services.poi;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import description.HTMLDescription;
import description.ServiceDescription;

/**
 * Servlet implementation class GetPOIs
 */
@WebServlet("/GetPOIs")
public class GetPOIs extends HttpServlet {
	private static final long serialVersionUID = 1L;
	private ServiceDescription description;
    /**
     * @see HttpServlet#HttpServlet()
     */
    public GetPOIs() {
        super();
        this.description = new HTMLDescription("Get POIs");
        this.description.addParameter("TimeStamp", "Start");
        this.description.addParameter("TimeStamp", "End");
        this.description.addParameter("Rectangle", "Region");
        this.description.addParameter("List Of Strings", "FriendsList");
        this.description.addParameter("Integer", "OrderBy");
        this.description.addParameter("Integer", "NoOfResults");
        this.description.addParameter("List of Strings", "Keywords");
        this.description.setReturnValue("List Of POI objects");
        this.description.setDescription("Web service used to return a list of objects satisfying certain criteria");
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		if(request.getParameter("info")!=null){
			response.getOutputStream().print(this.description.serialize());
		} else if(request.getParameter("userid")==null || request.getParameter("poiid")==null){
			response.sendError(HttpServletResponse.SC_BAD_REQUEST);
		} else {
			response.getOutputStream().print(true);
		}
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
	}

}
