package services.poi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.JSONException;
import org.json.simple.parser.JSONParser;

import dataBases.hBase.GPSTrajCharacteristics;
import dataBases.hBase.HBaseFunctions;
import datastore.client.PersistentHashMapClient;
import description.HTMLDescription;
import description.ServiceDescription;

/**
 * Servlet implementation class LogGPSTraces
 */
@WebServlet("/LogGPSTraces")
public class LogGPSTraces extends HttpServlet {
	private static final long serialVersionUID = 1L;
	private ServiceDescription description;
       
    /**
     * @see HttpServlet#HttpServlet()
     */
    public LogGPSTraces() {
        super();
        this.description = new HTMLDescription("Log GPS Traces");
        this.description.addParameter("List Of GPSTraces", "GPSTraces");
        this.description.setReturnValue("boolean");
        this.description.setDescription("Web service saves a list of GPS traces into repository of traces");
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		/*if(request.getParameter("info")!=null){
			response.getOutputStream().print(this.description.serialize());
		} 
		else if(request.getParameter("GPSTraces")==null){
			response.sendError(HttpServletResponse.SC_BAD_REQUEST);
		} 
		else {
			
		}*/
		
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		String token = null;
		double x = -1;
		double y = -1;
		String strTmstamp = null;
		int user_id ;
		String msgResponse = null;
		boolean result = true;
		ArrayList<GPSTrajCharacteristics> list = new ArrayList<GPSTrajCharacteristics>();
		GPSTrajCharacteristics gpsTraj = null;
		
		StringBuffer jb = new StringBuffer();
		String line = null;
		try {
			BufferedReader reader = request.getReader();
			while ((line = reader.readLine()) != null){
				jb.append(line);
			}
		} catch (Exception e) {  }
		
		String str = jb.toString();
		
		JSONParser parser = new JSONParser();
		
		Object obj = null;
		try {
			obj = parser.parse(str);
		} catch (org.json.simple.parser.ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		JSONObject jsonObj = (JSONObject)obj;
		JSONArray array = (JSONArray) jsonObj.get("traces");
		
		
		for ( int i = 0 ; i < array.size() ; i++ ){
			jsonObj = (JSONObject) array.get(i);
			token= (String) jsonObj.get("token");
			x = (Double) jsonObj.get("lat");
			y = (Double) jsonObj.get("lon");
			strTmstamp = (String) jsonObj.get("timestamp");
			PersistentHashMapClient user = new PersistentHashMapClient();
			user_id = user.getUserId(token);				
			gpsTraj = new GPSTrajCharacteristics(user_id,strTmstamp,String.valueOf(x),String.valueOf(y));
			list.add(gpsTraj);
		}
		
		String tableName = "GPSTrajectories";
		String columnName = "info";
		HBaseFunctions hBase = new HBaseFunctions();
		hBase.Configuration();
		hBase.insertRecords(tableName, columnName, list);
		
		msgResponse = "{\"result\":\"" + result + "\"}";
		/*response.setContentType("application/json;charset=UTF-8");
		response.getOutputStream().print(msgResponse);*/
		
		response.setCharacterEncoding("UTF-8");
		response.setHeader("Content-Type", "application/json");
		response.setHeader("charset", "utf-8");
		
		PrintWriter out = response.getWriter();
		out.write(msgResponse);
		
		
	}

}
