package gr.ntua.ece.cslab.modissense;

import gr.ntua.ece.cslab.modissense.containers.POI;
import gr.ntua.ece.cslab.modissense.containers.POIList;
import gr.ntua.ece.cslab.modissense.containers.UserPOIQueryArguments;

import java.io.IOException;
import java.util.List;

import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.BaseEndpointCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;

public class UserBasedQueryEndpoint extends BaseEndpointCoprocessor implements
		UserBasedQueryProtocol {
	public static String 	COLUMN_FAMILY = "cf",
							QUALIFIER = "";

	public byte[] getPOIs(UserPOIQueryArguments  args) throws IOException {
		List<Long> users = args.getUserIds();

		POIList results = new POIList();
		
		HRegion region = ((RegionCoprocessorEnvironment)getEnvironment()).getRegion();
		for(Long userId : users) {
			Get get = new Get(Bytes.toBytes(userId));
			Result res = region.get(get);
			if(res == null || res.isEmpty()) {
				System.err.format("Result for friend %d is null or empty\n", userId);
			} else {
				POIList list = new POIList();
				list.parseCompressedBytes(res.getValue(COLUMN_FAMILY.getBytes(), QUALIFIER.getBytes()));
				list.clearList(args.getxFrom(), args.getyFrom(), args.getxTo(), args.getyTo());
				list.clearList(args.getKeywords());
				list.chopLowScores(10);
				for(POI p : list.getPOIs())
					results.addPOI(p);
			}
		}
		
		
		return results.getCompressedBytes();
	}

}
