package gr.ntua.ece.cslab.modissense.benchmarks;

import gr.ntua.ece.cslab.modissense.client.UserPOIQuery;
import gr.ntua.ece.cslab.modissense.containers.UserPOIQueryArguments;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class Latency {

	public static List<Long> generateUsers(int usersCount) {
		Random rand = new Random();
		
		List<Long> userList = new ArrayList<Long>(usersCount);
		for(int i=0;i<usersCount;i++){
			userList.add(Math.abs(rand.nextLong()%50000 + 1));
		}
		
		Collections.sort(userList);
		return userList;

	}
	
	public static void main(String[] args) throws InterruptedException {
		if(args.length<3){
			System.err.println("I expect the following arguments:\n"
					+ "\tstart\n"
					+ "\tstep\n"
					+ "\tstop");
			System.exit(1);
		}
		
		int start = new Integer(args[0]);
		int step = new Integer(args[1]);
		int stop = new Integer(args[2]);
		int repeat = (args.length==4?new Integer(args[3]):1);
		
		
		UserPOIQueryArguments arguments = new UserPOIQueryArguments();
		arguments.setxFrom(0.0);
		arguments.setyFrom(0.0);
		arguments.setxTo(10.0);
		arguments.setyTo(10.0);
		arguments.addKeyword("bar");

		for(int i=start;i<=stop; i+=step){
			long time=0;
			for(int j=0;j<repeat;j++){
				arguments.setUserIds(generateUsers(i));
				
				UserPOIQuery q = new UserPOIQuery();
				q.setArguments(arguments);
				q.initialize();
				q.execute();
				q.finish();
				time+=q.getTime();
			}
			System.out.format("%d\t%d\n",i,time/repeat);
			
		}
	}
}
