package gr.ntua.ece.cslab.modissense.benchmarks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

import gr.ntua.ece.cslab.modissense.client.UserPOIQuery;
import gr.ntua.ece.cslab.modissense.containers.UserPOIQueryArguments;

public class Throughput {
	
	public static List<Long> generateUsers(int usersCount) {
		Random rand = new Random();
		
		List<Long> userList = new ArrayList<Long>(usersCount);
		for(int i=0;i<usersCount;i++){
			userList.add(Math.abs(rand.nextLong()%50000 + 1));
		}
		
		Collections.sort(userList);
		return userList;

	}

	
	public static void main(String[] args) throws InterruptedException {
		if(args.length<3){
			System.err.println("I expect the following arguments:\n"
					+ "\tstart\n"
					+ "\tstep\n"
					+ "\tstop");
			System.exit(1);
		}
		
		int start = new Integer(args[0]);
		int step = new Integer(args[1]);
		int stop = new Integer(args[2]);
		int repeat = (args.length==4?new Integer(args[3]):1);

		
		for(int i=start; i<=stop; i+=step){
			long time=0;
			for(int k=0;k<repeat;k++) {
				List<QueryThread> threads = new LinkedList<QueryThread>();
				for(int j=1;j<=i;j++){
					UserPOIQueryArguments arguments = new UserPOIQueryArguments();
					arguments.setxFrom(0.0);
					arguments.setyFrom(0.0);
					arguments.setxTo(10.0);
					arguments.setyTo(10.0);
					arguments.addKeyword("bar");
					arguments.setUserIds(generateUsers(200));
					threads.add(new QueryThread(arguments));
				}
				for(Thread t:threads)
					t.start();
				for(Thread t:threads)
					t.join();
				
				long sum=0l;
				for(QueryThread t:threads) {
					sum+=t.getTime();
				}
				time+=sum/threads.size();
			}
			System.out.format("%d\t%d\n",i,time/repeat);
		}	

	}

}

class QueryThread extends Thread {
	
	private long time;
	private UserPOIQueryArguments arguments;
	public QueryThread(UserPOIQueryArguments arguments) {
		this.arguments = arguments;
	}
	
	@Override
	public synchronized void start() {
		super.start();
	}
	
	@Override
	public void run() {
		super.run();
		 UserPOIQuery q = new UserPOIQuery();
		 q.setArguments(this.arguments);
		 this.time = System.currentTimeMillis();
		 q.initialize();
		 try {
			q.execute();
		} catch (InterruptedException e) {
			e.printStackTrace();
			System.exit(1);
		}
		 this.time = System.currentTimeMillis() - time;
		 q.finish();
	}
	
	public long getTime() {
		return this.time;
	}
}
