package gr.ntua.ece.cslab.modissense.client;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;

import gr.ntua.ece.cslab.modissense.UserBasedQueryProtocol;
import gr.ntua.ece.cslab.modissense.containers.POI;

import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;


public class TerminalClient {
	
	private static int usersToFetch = 10;
	private static HTable table;
	private static Long[] cuts;
	
	private static void getCuts() throws IOException{
		Set<Long> cuts = new TreeSet<Long>();
		Pair<byte[][], byte[][]> pair = table.getStartEndKeys();
		for(int i=0;i<pair.getFirst().length;i++){
			byte[] start= pair.getFirst()[i], stop = pair.getSecond()[i];
			if(start.length>0)
				cuts.add(Bytes.toLong(start));
			if(stop.length>0)
				cuts.add(Bytes.toLong(stop));
		}
		cuts = new TreeSet<Long>();
		cuts.toArray(TerminalClient.cuts);

	}
	
	public static void main(String[] args) throws IOException {
		table = new HTable(HBaseConfiguration.create(), "TestingTable");
		getCuts();
		
		UserBasedQueryProtocol prot = table.coprocessorProxy(UserBasedQueryProtocol.class, Bytes.toBytes(0));
		Random rand = new Random();
		ByteBuffer buffer = ByteBuffer.allocate(usersToFetch*Long.SIZE/8);
		
		for(int i=0;i<usersToFetch;i++) {
			Long userId=Math.abs(rand.nextLong()%100+1);
			System.out.println("User id:\t"+userId);
			buffer.putLong(userId);
		}

//		for(byte[] poiBytes : prot.getPOIs(buffer.array())){
//			POI poi = new POI();
//			poi.parseBytes(poiBytes);
//			System.out.println(poi);
//		}
		System.out.println();
		
		table.close();
	}
}
