package gr.ntua.ece.cslab.modissense.client;

import gr.ntua.ece.cslab.modissense.UserBasedQueryProtocol;
import gr.ntua.ece.cslab.modissense.containers.POIList;
import gr.ntua.ece.cslab.modissense.containers.UserPOIQueryArguments;

import java.io.IOException;
import java.nio.ByteBuffer;

import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.util.Bytes;

/**
 * Thread used to hit a specific region server and parses the results
 * @author Giannis Giannakopoulos
 *
 */
public class UserPOIRegionThread extends Thread {

	private HTable table; 
	private UserPOIQueryArguments arguments;
	private long execTime;
	private POIList results;
	public UserPOIRegionThread(HTable table, UserPOIQueryArguments arguments) {
		super();
		this.table = table;
		this.arguments = arguments;
		this.results = new POIList();
	}
	
	@Override
	public synchronized void start() {
		super.start();
		this.execTime = System.currentTimeMillis();
	}
	
	@Override
	public void run() {
		super.run();
		ByteBuffer buffer = ByteBuffer.allocate(arguments.getUserIds().size()*Long.SIZE/8);
		for(Long u : this.arguments.getUserIds())
			buffer.putLong(u);
		
		UserBasedQueryProtocol prot = this.table.coprocessorProxy(UserBasedQueryProtocol.class, Bytes.toBytes(this.arguments.getUserIds().get(0)));
		
		try {
			results.parseCompressedBytes(prot.getPOIs(arguments));
		} catch (IOException e) {
			e.printStackTrace();
		}
		
		
		this.execTime = System.currentTimeMillis() - this.execTime;
	}
	
	public long getExecTime(){
		return this.execTime;
	}
	
	public POIList getResults() {
		return this.results;
	}
}
