package gr.ntua.ece.cslab.modissense.containers;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;

import org.apache.hadoop.hbase.util.Bytes;

public class POI implements Serializable{

	private Long id;
	private String name;
	private Double x, y;
	private Set<String> keywords;
	private Double score;
	
	public POI() {
		this.id = new Long(Long.MAX_VALUE);
		this.name = new String();
		this.x = new Double(Double.MAX_VALUE);
		this.y = new Double(Double.MAX_VALUE);
		this.keywords = new HashSet<String>();
		this.score = new Double(Long.MAX_VALUE);
	}
	
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Double getX() {
		return x;
	}
	public void setX(double x) {
		this.x = x;
	}
	public Double getY() {
		return y;
	}
	public void setY(double y) {
		this.y = y;
	}
	public Set<String> getKeywords() {
		return keywords;
	}
	public void setKeywords(Set<String> keywords) {
		this.keywords = keywords;
	}
	
	public Double getScore() {
		return score;
	}

	public void setScore(Double score) {
		this.score = score;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long poiId) {
		this.id = poiId;
	}
	
	@Override
	public String toString() {
		return "["+this.id+"] "+this.name+" @ "+"("+this.x+", "+this.y+") tagged with "+this.keywords +" with score "+this.score;
	}

	@Override
	public void parseBytes(byte[] bytes) {
		int index = 0;
		
		ByteBuffer buffer = ByteBuffer.wrap(bytes);
		this.id = buffer.getLong(index);
		index+= Long.SIZE/8;
		
		int sizeOfName = buffer.getInt(index);
		index+= Integer.SIZE/8;
		
		this.name = new String(bytes, index, sizeOfName);
		index+=this.name.length();
		
		this.x = buffer.getDouble(index);
		index+= Double.SIZE/8;
		
		this.y = buffer.getDouble(index);
		index+=Double.SIZE/8;
		
		this.score = buffer.getDouble(index);
		index+=Double.SIZE/8;
		
		int keywordsCount = buffer.getInt(index);
		index+=Integer.SIZE/8;
		
		this.keywords = new HashSet<String>();
		
		for(int i=0;i<keywordsCount;i++){
			int keywordSize = buffer.getInt(index);
			index+=Integer.SIZE/8;
			String keyword = new String(bytes, index,keywordSize);
			index+=keyword.length();
			this.keywords.add(keyword);
		}
		
	}

	@Override
	public byte[] getBytes() {
		int totalSize =		Long.SIZE/8						// poi id	 	
							+ Integer.SIZE/8 + this.name.length() // bytes needed to write string size + string
							+ Double.SIZE/8 					// x coord
							+ Double.SIZE/8						// y coord
							+ Double.SIZE/8						// score
							+ Integer.SIZE/8;					// size of set
		for(String s:keywords)									// string size + actual string for all keywords
			totalSize+=Integer.SIZE/8 + s.length();
		byte[] serializable = new byte[totalSize];
		
		ByteBuffer buffer = ByteBuffer.wrap(serializable);
		buffer.put(Bytes.toBytes(this.id));
		buffer.put(Bytes.toBytes(this.name.length()));
		buffer.put(this.name.getBytes());
		buffer.put(Bytes.toBytes(this.x));
		buffer.put(Bytes.toBytes(this.y));
		buffer.put(Bytes.toBytes(this.score));
		buffer.put(Bytes.toBytes(this.keywords.size()));
		for(String s : this.keywords) {
			buffer.put(Bytes.toBytes(s.length()));
			buffer.put(s.getBytes());
		}
		return serializable;
	}
	
	public static void main(String[] args) {
		System.out.println("Starting main execution");
		POI poi = new POI();
		
		poi.setId(1l);
		poi.setName("Fraoulokipos");
		poi.setX(10.2);
		poi.setY(10.3);
		poi.setScore(55.0);
		Set<String> keyws = new HashSet<String>();
		keyws.add("beer");
		keyws.add("wine");
		poi.setKeywords(keyws);
		System.out.println("Old poi:\t"+poi);
		
		byte[] serial = poi.getBytes();
		
		System.out.println("Bytes serialized:\t"+serial.length);
		
		POI newPoi = new POI();
		newPoi.parseBytes(serial);
		System.out.println("New poi:\t"+newPoi);
	}
	
}
