package gr.ntua.ece.cslab.modissense.containers;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import org.apache.hadoop.io.Writable;

/**
 * Class used to pass arguments to the coprocessor using a single struct.
 * @author Giannis Giannakopoulos
 *
 */
public class UserPOIQueryArguments implements Writable{
	
	private List<Long> userIds;
	private double xFrom, yFrom;
	private double xTo, yTo;
	private List<String> keywords;
	
	public UserPOIQueryArguments() {
		this.userIds = new LinkedList<Long>();
		this.keywords = new LinkedList<String>();
	}
	
	public List<Long> getUserIds() {
		return userIds;
	}
	public void setUserIds(List<Long> userIds) {
		this.userIds = userIds;
	}
	public double getxFrom() {
		return xFrom;
	}
	public void setxFrom(double xFrom) {
		this.xFrom = xFrom;
	}
	public double getyFrom() {
		return yFrom;
	}
	public void setyFrom(double yFrom) {
		this.yFrom = yFrom;
	}
	public double getxTo() {
		return xTo;
	}
	public void setxTo(double xTo) {
		this.xTo = xTo;
	}
	public double getyTo() {
		return yTo;
	}
	public void setyTo(double yTo) {
		this.yTo = yTo;
	}
	public List<String> getKeywords() {
		return keywords;
	}
	public void setKeywords(List<String> keywords) {
		this.keywords = keywords;
	}
	
	public void addUserId(Long userId){
		if(this.userIds!=null)
			this.userIds.add(userId);
	}
	
	public void addKeyword(String keyword){
		if(this.keywords!=null)
			this.keywords.add(keyword);
	}
	
	/**
	 * Returns the div: (number of users)/(max user id - min user id)
	 * @return
	 */
	public double getUsersDensity(){
		if(this.userIds==null)
			return 0;
		if(this.userIds.get(0)==this.userIds.get(this.userIds.size()-1))
			return Double.MAX_VALUE;
		return (this.userIds.size())/(this.userIds.get(this.userIds.size()-1) - this.userIds.get(0));
	}

	public UserPOIQueryArguments clone() {
		UserPOIQueryArguments arguments = new UserPOIQueryArguments();
		arguments.setKeywords(this.keywords);
		arguments.setUserIds(this.userIds);
		arguments.setxFrom(this.getxFrom());
		arguments.setyFrom(this.getyFrom());
		arguments.setxTo(this.getxTo());
		arguments.setyTo(this.getyTo());
		return arguments;
	}
	
	public void readFields(DataInput in) throws IOException {
		this.userIds = new LinkedList<Long>();
		this.keywords = new LinkedList<String>();
		
		int users = in.readInt();
		for(int i=0;i<users;i++)
			this.userIds.add(in.readLong());
		this.xFrom = in.readDouble();
		this.yFrom = in.readDouble();
		this.xTo = in.readDouble();
		this.yTo = in.readDouble();
		
		int keyws = in.readInt();
		for(int i=0;i<keyws;i++)
			this.keywords.add(in.readUTF());
		
		
	}

	public void write(DataOutput out) throws IOException {
		out.writeInt(this.userIds.size());
		for(Long u:userIds)
			out.writeLong(u);
		out.writeDouble(this.xFrom);
		out.writeDouble(this.yFrom);
		out.writeDouble(this.xTo);
		out.writeDouble(this.yTo);
		out.writeInt(this.keywords.size());
		for(String s:this.keywords)
			out.writeUTF(s);
	}
	

}
