package services.callbacks;

import java.io.IOException;

import java.util.HashMap;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import datastore.client.PersistentHashMapClient;

import services.users.Register;
import session.SessionManagementIM;
import supportingClasses.RunningWebService;
import supportingClasses.Utils;


import entites.SNDetails;
import entites.User;
import fi.foyt.foursquare.api.FoursquareApi;
import fi.foyt.foursquare.api.FoursquareApiException;
import fi.foyt.foursquare.api.Result;
import fi.foyt.foursquare.api.entities.CompleteUser;

/**
 * Servlet implementation class CallbackServlet
 * 
 * @author Giagkos Mytilinis
 */

public class FoursquareCallback extends RunningWebService {
	
private static final long serialVersionUID = 1L;
    
    /**
     * @see HttpServlet#HttpServlet()
     */
    public FoursquareCallback() {
        super();
        serviceName = "Foursquare Callback: ";
        DEBUG = true;
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
        FoursquareApi foursquareApi = new FoursquareApi(Register.getFoursquareClientID()
        		,Register.getFoursquareClientSecret(),Register.getFoursquareCallback());

        String code=request.getParameter("code");
        
        HttpSession session = request.getSession();
        
        try {

              foursquareApi.authenticateCode(code);
              String accessToken = foursquareApi.getOAuthToken();
               
              Result<CompleteUser> result = foursquareApi.user("self");
              if (result.getMeta().getCode() == 200) {
                  CompleteUser fUser = result.getResult();
                  if(DEBUG)System.out.println(serviceName+"foursquare user "+fUser.getId());
                  
                /*
      			 * Search in the DB according to social network and userID. This search can return
      			 * either one or none results.
      			 */

                  SNDetails socialNetworkInfo = new SNDetails();
      			socialNetworkInfo.setSnName("foursquare");
      			socialNetworkInfo.setSnIdentifier(fUser.getId());
      			    			
      			List<HashMap<String, String>> results = socialNetworkInfo.read();
      			

    			String token = null;
    			PersistentHashMapClient hashClient = new PersistentHashMapClient();
    			
    			if(results.size()==0){
    				
    				/*
    				 *  If there are no results, we can either add a new Modissense account
    				 *  or connect a social network account to an existing one.
    				 */
    				
    				socialNetworkInfo.setSnToken(accessToken);
    				
    				if(!((String)session.getAttribute("uidtoken")).equals("null")){
    					
    					if(DEBUG)System.out.println(serviceName+"Connect Foursquare account to existing Modissense user.");
    					
    					token = (String) session.getAttribute("uidtoken");
    					if(DEBUG)System.out.println(serviceName+"user token = "+token);
    					
    					int usid = hashClient.getUserId(token);
    					
    					socialNetworkInfo.setUserId(usid);
    					if(socialNetworkInfo.create()){
    						System.out.println(serviceName+"sn_list entry created successfully.");
    					}
    					else
    						System.out.println(serviceName+"sn_list entry failed");
    				}else{
    					if(DEBUG)System.out.println(serviceName+"Create new Modissense user.");
    					
    					User newUser = new User();
    					newUser.setUsername(fUser.getFirstName()+fUser.getLastName());
    					if(newUser.create()){
    						if(DEBUG)System.out.println(serviceName+"user entry created successfully.");
    					
    						User theSameUser = new User(fUser.getFirstName()+fUser.getLastName());
    						socialNetworkInfo.setUserId(theSameUser.getId());
    						
    						token = Utils.randomStringGenerator(32); 
    						if(DEBUG)System.out.println(serviceName+"New user acquired token = "+token);
    						hashClient.add(token, theSameUser.getId());
    						
    						if(socialNetworkInfo.create()){
    							System.out.println(serviceName+"sn_list entry created successfully.");
    						}
    						else
    							System.out.println(serviceName+"sn_list entry failed");
    					}
    					else
    						System.out.println(serviceName+"user entry failed.");
    				}
    			} else{
    				/*
    				 * In the DB there is a twitter account with the specific user id. Update twitter access token
    				 * as it may have expired and check if there is a valid session token for this user.
    				 */
    				
    				HashMap<String, String> tokensToUpdate = new HashMap<String, String>();
					tokensToUpdate.put("sn_token", "'"+accessToken+"'");
					socialNetworkInfo.update(tokensToUpdate);
    				
    				if(hashClient.getSession(socialNetworkInfo.getUserId()).equals("null")){
    					token = Utils.randomStringGenerator(32); 
    					hashClient.add(token, socialNetworkInfo.getUserId());
    					if(DEBUG)System.out.println(serviceName+"Existing user got new token. Token = "+token);
					}else{
						token=hashClient.getSession(socialNetworkInfo.getUserId());
						if(DEBUG)System.out.println(serviceName+"Existing user logged in. Valid token= "+token);
					}
    			}
    			
    			response.sendRedirect(response.encodeRedirectURL((String)session.getAttribute("callback")+"&uid="+token));

              }
              else {
                  System.out.println(serviceName+"Error occured: ");
                  System.out.println(serviceName+"  code: " + result.getMeta().getCode());
                  System.out.println(serviceName+"  type: " + result.getMeta().getErrorType());
                  System.out.println(serviceName+"  detail: " + result.getMeta().getErrorDetail());
              }
              
        } catch (FoursquareApiException e) {
              e.printStackTrace();
        }		
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
	}

}
