package services.callbacks;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import datastore.client.PersistentHashMapClient;

import entites.SNDetails;
import entites.User;


import services.users.Register;
import session.SessionManagementIM;
import supportingClasses.RunningWebService;
import supportingClasses.Utils;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;

import twitter4j.auth.AccessToken;
import twitter4j.auth.RequestToken;
import twitter4j.conf.ConfigurationBuilder;


/**
 * Servlet implementation class CallbackServlet
 * 
 * 
 * @author Giagkos Mytilinis
 */
public class TwitterCallback extends RunningWebService {
	
	private static final long serialVersionUID = 1L;

    /**
     * @see HttpServlet#HttpServlet()
     */
    public TwitterCallback() {
        super();
        serviceName = "Twitter Callback: ";
        DEBUG = true;
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
    
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
	
		ConfigurationBuilder cb = new ConfigurationBuilder();
		cb.setDebugEnabled(true)
		  .setIncludeEntitiesEnabled(true)
		  .setUseSSL(true);
		
		Twitter twitter = new TwitterFactory(cb.build()).getInstance();
		
		HttpSession session = request.getSession();
				
		twitter.setOAuthConsumer(Register.getTwitterConsumerToken(), Register.getTwitterConsumerSecret());
		try {
			AccessToken accessToken = twitter.getOAuthAccessToken(new RequestToken((String) session.getAttribute("token"), 
					(String) session.getAttribute("tokenSecret")),request.getParameter("oauth_verifier"));
            twitter.setOAuthAccessToken(accessToken);
			
			session.setAttribute("acc_token", accessToken.getToken());
			session.setAttribute("acc_tokenSecret", accessToken.getTokenSecret());
			
			ConfigurationBuilder userConfBuilder = new ConfigurationBuilder();
			userConfBuilder.setDebugEnabled(true)
			  .setOAuthConsumerKey(Register.getTwitterConsumerToken())
			  .setOAuthConsumerSecret(Register.getTwitterConsumerSecret())
			  .setOAuthAccessToken(accessToken.getToken())
			  .setOAuthAccessTokenSecret(accessToken.getTokenSecret())
			  .setIncludeEntitiesEnabled(true);
			
			TwitterFactory tf = new TwitterFactory(userConfBuilder.build());
			Twitter userTwitter = tf.getInstance ();
			
			/*
			 * Search in the DB according to social network and userID. This search can return
			 * either one or none results.
			 */
			
			SNDetails socialNetworkInfo = new SNDetails();
			socialNetworkInfo.setSnName("twitter");
			socialNetworkInfo.setSnIdentifier(Long.toString(userTwitter.getId()));
					
			List<HashMap<String, String>> results = socialNetworkInfo.read();
			
			String token = null; 
			
			PersistentHashMapClient hashClient = new PersistentHashMapClient();
			
			if(results.size()==0){
				/*
				 *  If there are no results, we can either add a new Modissense account
				 *  or connect a social network account to an existing one.
				 */
				socialNetworkInfo.setSnToken(accessToken.getToken());
				socialNetworkInfo.setSnTokenSecret(accessToken.getTokenSecret());
				
				if(!((String)session.getAttribute("uidtoken")).equals("null")){
						
					if(DEBUG)System.out.println(serviceName+"Connect Twitter account to existing Modissense user.");
					
					token = (String) session.getAttribute("uidtoken");
					if(DEBUG)System.out.println(serviceName+"user token = "+token);
					
					int usid = hashClient.getUserId(token);
						
					socialNetworkInfo.setUserId(usid);
					if(socialNetworkInfo.create()){
						System.out.println(serviceName+"sn_list entry created successfully.");
					}
					else
						System.out.println(serviceName+"sn_list entry failed");
				}else{
					if(DEBUG)System.out.println(serviceName+"Create new Modissense user.");
					
					User newUser = new User();
					newUser.setUsername(userTwitter.getScreenName());
					if(newUser.create()){
						if(DEBUG)System.out.println(serviceName+"user entry created successfully.");
						User theSameUser = new User(userTwitter.getScreenName());
						socialNetworkInfo.setUserId(theSameUser.getId());
						
						token = Utils.randomStringGenerator(32); 
						if(DEBUG)System.out.println(serviceName+"New user acquired token = "+token);
						hashClient.add(token, theSameUser.getId());
						
						if(socialNetworkInfo.create()){
							System.out.println(serviceName+"sn_list entry created successfully.");
						}
						else
							System.out.println(serviceName+"sn_list entry failed");
					}
					else
						System.out.println(serviceName+"user entry failed.");
				}
			} else{
				/*
				 * In the DB there is a twitter account with the specific user id. Update twitter access token
				 * as it may have expired and check if there is a valid session token for this user.
				 */
				HashMap<String, String> tokensToUpdate = new HashMap<String, String>();
				tokensToUpdate.put("sn_token", "'"+accessToken.getToken()+"'");
				tokensToUpdate.put("sn_token_secret", "'"+accessToken.getTokenSecret()+"'");
				socialNetworkInfo.update(tokensToUpdate);
				
				if(hashClient.getSession(socialNetworkInfo.getUserId()).equals("null")){
						
					token = Utils.randomStringGenerator(32); 
					hashClient.add(token, socialNetworkInfo.getUserId());
					if(DEBUG)System.out.println(serviceName+"Existing user got new token. Token = "+token);
				}else{
					token=hashClient.getSession(socialNetworkInfo.getUserId());
					if(DEBUG)System.out.println(serviceName+"Existing user logged in. Valid token= "+token);
				}
			}
			
			
		    response.sendRedirect(response.encodeRedirectURL((String)session.getAttribute("callback")+"&uid="+token));
			
			
		} catch (TwitterException e) {
		
			e.printStackTrace();
		}
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
	}

}