package services.poi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;


import dataBases.postgres.PoiCharacteristics;
import dataBases.postgres.PoiCriteria;
import dataBases.postgres.PostgreSQLFunctions;
import datastore.client.PersistentHashMapClient;
import description.HTMLDescription;
import description.ServiceDescription;

/**
 * Servlet implementation class GetPOIs
 */
@WebServlet("/GetPOIs")
public class GetPOIs extends HttpServlet {
	private static final long serialVersionUID = 1L;
	private ServiceDescription description;
    /**
     * @see HttpServlet#HttpServlet()
     */
    public GetPOIs() {
        super();
        this.description = new HTMLDescription("Get POIs");
        this.description.addParameter("TimeStamp", "Start");
        this.description.addParameter("TimeStamp", "End");
        this.description.addParameter("Rectangle", "Region");
        this.description.addParameter("List Of Strings", "FriendsList");
        this.description.addParameter("String", "OrderBy");
        this.description.addParameter("Integer", "NoOfResults");
        this.description.addParameter("List of Strings", "Keywords");
        this.description.setReturnValue("List Of POI objects"); 
        this.description.setDescription("Web service used to return a list of objects satisfying certain criteria");
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		if(request.getParameter("info")!=null){
			response.getOutputStream().print(this.description.serialize());
		} 
		else{
			PostgreSQLFunctions postgres = new PostgreSQLFunctions();
			ArrayList<PoiCharacteristics> listOfPOIs = null;
			ArrayList<Integer> friendsIdList = null;
			Connection con = null;
			int user_id;

			String startTime =  request.getParameter("stime"); 
			String endTime = request.getParameter("etime");
			String x1Region = request.getParameter("x1");
			String y1Region = request.getParameter("y1");
			String x2Region = request.getParameter("x2");
			String y2Region = request.getParameter("y2");
			String friends = request.getParameter("friends");
			String keywords = request.getParameter("keywords");
			String orderBy = request.getParameter("orderby");
			String numberOfResults = request.getParameter("nresults");	
			String msgChoice = request.getParameter("format");
			String token = request.getParameter("token");
			
			double x1;
			double y1;
			double x2;
			double y2;
			int nOfResults;
			String del = ",";
			String []temp = null;
			
			PersistentHashMapClient user = new PersistentHashMapClient();
			user_id = user.getUserId(token);

			if (x1Region.equals("") && y1Region.equals("") && x2Region.equals("") && y2Region.equals("") ){
				x1 = -1;
				y1 = -1;
				x2 = -1;
				y2 = -1;
 			}
			else{
				x1 = Double.parseDouble(x1Region);
				y1 = Double.parseDouble(y1Region);
				x2 = Double.parseDouble(x2Region);
				y2 = Double.parseDouble(y2Region);
			}
			
			if ( numberOfResults.equals("") ){
				nOfResults = -1;
			}
			else{
				nOfResults = Integer.parseInt(numberOfResults);
			}
			
			if (orderBy.equals("")){
				orderBy= null;
			}
			
			if (friends.equals("")){
				friendsIdList = null;
			}
			else{
				friendsIdList = new ArrayList<Integer>();
				if (!friends.contains(",")){
					friendsIdList.add(user.getUserId(friends));
				}
				else{
					temp = friends.split(del);
					for (int i = 0 ; i < temp.length ; i++){
						friendsIdList.add(user.getUserId(temp[i]));
					}
				}
			}
			
			if (keywords.equals("")){
				keywords = null;
			}
			else{
				keywords = keywords.toLowerCase();
				keywords = keywords.replaceAll(" ","");
			}
			

			java.sql.Timestamp start_time = null;
			java.sql.Timestamp end_time = null;
			
			SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
	        java.util.Date parsedDate = null;
			
			if ( !startTime.equals("") ){
				parsedDate = null;
				try {
					parsedDate = dateFormat.parse(startTime);
				} catch (ParseException e2) {
					// TODO Auto-generated catch block
					e2.printStackTrace();
				}
		        start_time = new java.sql.Timestamp(parsedDate.getTime());
			}
			else {
				start_time = null;
			}
			
			if ( !endTime.equals("") ){
				try {
					parsedDate = dateFormat.parse(endTime);
				} catch (ParseException e2) {
					// TODO Auto-generated catch block
					e2.printStackTrace();
				}
				end_time = new java.sql.Timestamp(parsedDate.getTime());
			}
			else{
				end_time = null;
			}
			
			String msgResponse = null;

			PoiCriteria poiCrit = new PoiCriteria(user_id,start_time,end_time,x1,y1,x2,y2,friendsIdList,orderBy,nOfResults,keywords);
			
			try {
				con = postgres.OpenConnection();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
					
			try {
				listOfPOIs = postgres.getPOIs(con, poiCrit);
			} catch (SQLException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			
			try {
				postgres.CloseConnection(con);
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
			
			if ( listOfPOIs != null ){
				if (msgChoice.equals("json")){
					msgResponse = "{\"poiList\":[" +  listOfPOIs.get(0).toJson();
			        for (int i = 1 ; i < listOfPOIs.size() ; i ++ ){
			            msgResponse = msgResponse + "," + listOfPOIs.get(i).toJson();
			        }
			        msgResponse = msgResponse + "]}";
				}
				else{
					msgResponse = "callback({\"poiList\":[" + listOfPOIs.get(0).toJson();
			        for (int i = 1 ; i < listOfPOIs.size() ; i ++ ){
			            msgResponse = msgResponse + "," + listOfPOIs.get(i).toJson();
			        }
			        msgResponse = msgResponse + "]})";
				}
			}
			else{
				if (msgChoice.equals("json")){
					msgResponse = "{\"poiList\":[]}";
				}
				else{
					msgResponse = "callback({\"poiList\":[]})";

				}
				
			}
			response.setCharacterEncoding("UTF-8");
			response.setHeader("Content-Type", "application/json");
			response.setHeader("charset", "utf-8");
			
			PrintWriter out = response.getWriter();
			out.write(msgResponse);
			//response.setContentType("application/json;charset=utf-8");
			//response.getOutputStream().print(msgResponse);
		}
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
		
		}
	//}

}
